﻿var duplicatePanelists = {
    page: null,
    context: null,
    importedPanelistId: 0,
    existingPanelistIds: [],
    currentPanelistIndex: 0
}

$(document).ready(function () {
    var pathName = window.location.pathname;
    duplicatePanelists.context = $(".v-duplicatePanelistDetails");
    duplicatePanelists.importedPanelistId = $(".v-importedId", duplicatePanelists.context).text();
    duplicatePanelists.existingPanelistIds = $(".v-existingIds", duplicatePanelists.context).text().split(",");

    SetEvents();
});

function SetEvents() {
    $(".v-prevPanelist", duplicatePanelists.context).click(function () {
        if (duplicatePanelists.currentPanelistIndex == 0) {
            duplicatePanelists.currentPanelistIndex = duplicatePanelists.existingPanelistIds.length - 1;
        }
        else {
            duplicatePanelists.currentPanelistIndex--;
        }

        LoadPanelistCompare();
    });

    $(".v-nextPanelist", duplicatePanelists.context).click(function () {
        if (duplicatePanelists.currentPanelistIndex == duplicatePanelists.existingPanelistIds.length - 1) {
            duplicatePanelists.currentPanelistIndex = 0;
        }
        else {
            duplicatePanelists.currentPanelistIndex++;
        }

        LoadPanelistCompare();
    });

    $(".v-resolutionButton", duplicatePanelists.context).click(function () {
        var resolution = $(this).attr("data-resolution");
        a4.parent().panelImportation.updatePanelistsResolution("UpdatePanelistResolution", { panelistId: duplicatePanelists.importedPanelistId, resolution: resolution });
        modalDialog.close();
    });
}

function LoadPanelistCompare() {
    var importedPanelistId = duplicatePanelists.importedPanelistId;
    var existingPanelistId = duplicatePanelists.existingPanelistIds[duplicatePanelists.currentPanelistIndex];

    a4.callServerMethod(a4.getAction("LoadPanelistsCompare", "Import", "Panel"), { importedPanelistId: importedPanelistId, existingPanelistId: existingPanelistId }, function (result) {
        $(".v-panelistIndex", duplicatePanelists.context).text(duplicatePanelists.currentPanelistIndex + 1);
        $(".v-duplicatePanelistDetails", duplicatePanelists.context).html(result);
    });
}